@extends('layouts.modern')

@section('title', 'Medical Blog - ENT Care Center')
@section('meta_description', 'Latest news, tips and information about ENT health from our experts.')

@section('content')
<!-- Page Header -->
<section class="relative h-40 md:h-48 bg-gradient-to-br from-indigo-600 via-blue-600 to-cyan-500 flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-black opacity-30"></div>
    <div class="absolute inset-0 opacity-20">
        <div class="absolute top-0 left-0 w-full h-full" style="background-image: radial-gradient(circle at 2px 2px, white 1px, transparent 0); background-size: 40px 40px;"></div>
    </div>
    <div class="relative z-10 text-center text-white px-4">
        <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-bold mb-4">Health Blog</h1>
        <p class="text-lg sm:text-xl text-white/90">Insights and updates from our ENT specialists</p>
    </div>
</section>

<!-- Blog List -->
<section class="py-6 md:py-10 bg-gradient-to-br from-gray-50 to-indigo-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
            @forelse($blogs as $index => $blog)
            <div x-data="{ hover: false }"
                 @mouseenter="hover = true"
                 @mouseleave="hover = false"
                 x-init="$el.style.opacity = '1'; $el.style.transform = 'translateY(0)';"
                 x-intersect="if ($el.style.opacity === '1') { $el.style.opacity = '0'; $el.style.transform = 'translateY(30px)'; setTimeout(() => { $el.style.transition = 'all 0.6s ease-out'; $el.style.opacity = '1'; $el.style.transform = 'translateY(0)'; }, {{ $index * 100 }}); }"
                 class="bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300 group flex flex-col h-full">
                
                <!-- Blog Image -->
                <div class="relative h-48 md:h-56 overflow-hidden">
                    @if($blog->image)
                        <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->title }}" class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-500">
                    @else
                        <div class="w-full h-full bg-gradient-to-br from-indigo-500 to-blue-500 flex items-center justify-center">
                            <i class="fas fa-newspaper text-white text-5xl opacity-30"></i>
                        </div>
                    @endif
                    <div class="absolute top-4 left-4">
                        <span class="bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wider">ENT Health</span>
                    </div>
                </div>

                <!-- Content -->
                <div class="p-5 md:p-6 flex flex-col flex-grow">
                    <div class="flex items-center text-xs text-gray-500 mb-3 space-x-4">
                        <span class="flex items-center"><i class="far fa-calendar-alt mr-1"></i> {{ $blog->published_at->format('M d, Y') }}</span>
                        <span class="flex items-center"><i class="far fa-eye mr-1"></i> {{ $blog->views }} views</span>
                    </div>
                    
                    <h3 class="text-xl font-bold text-gray-900 mb-3 group-hover:text-blue-600 transition-colors line-clamp-2">
                        <a href="{{ route('blog.show', $blog->slug) }}">{{ $blog->title }}</a>
                    </h3>
                    
                    <p class="text-gray-600 text-sm md:text-base mb-4 line-clamp-3 leading-relaxed">
                        {{ $blog->short_description }}
                    </p>
                    
                    <div class="mt-auto pt-4 border-t border-gray-100 flex items-center justify-between">
                        <span class="text-xs font-semibold text-gray-500 flex items-center">
                            <i class="far fa-user mr-1"></i> By {{ $blog->author->name ?? 'ENT Care Center' }}
                        </span>
                        <a href="{{ route('blog.show', $blog->slug) }}" 
                           class="inline-flex items-center text-blue-600 font-bold hover:text-blue-800 transition-colors text-sm">
                            Read More
                            <svg class="w-4 h-4 ml-1 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            @empty
            <div class="col-span-full text-center py-20 bg-white rounded-3xl shadow-sm border border-gray-100">
                <div class="w-20 h-20 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-book-open text-gray-300 text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No Blog Posts Yet</h3>
                <p class="text-gray-500 max-w-md mx-auto">We're currently working on exciting new content for you. Please check back soon!</p>
            </div>
            @endforelse
        </div>

        <!-- Pagination -->
        <div class="mt-10 md:mt-12">
            {{ $blogs->links() }}
        </div>
    </div>
</section>

<!-- Newsletter Section -->
<section class="py-6 md:py-10 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-gradient-to-r from-blue-600 to-indigo-700 rounded-3xl p-6 md:p-12 text-center text-white relative overflow-hidden shadow-2xl">
            <!-- Decorative circles -->
            <div class="absolute top-0 right-0 -mr-20 -mt-20 w-64 h-64 bg-white opacity-10 rounded-full"></div>
            <div class="absolute bottom-0 left-0 -ml-20 -mb-20 w-64 h-64 bg-white opacity-10 rounded-full"></div>
            
            <div class="relative z-10 max-w-2xl mx-auto">
                <h2 class="text-2xl md:text-4xl font-bold mb-4">Stay Informed & Healthy</h2>
                <p class="text-lg text-blue-100 mb-8 leading-relaxed">Subscribe to our newsletter and receive the latest health tips, medical news, and updates directly in your inbox.</p>
                
                <form class="flex flex-col sm:flex-row gap-3 max-w-lg mx-auto">
                    <input type="email" placeholder="Your email address" class="flex-grow px-6 py-4 rounded-full text-gray-900 focus:outline-none focus:ring-4 focus:ring-blue-300 transition-all text-base shadow-lg" required>
                    <button type="submit" class="bg-indigo-900 text-white px-8 py-4 rounded-full font-bold hover:bg-indigo-950 transition-all transform hover:scale-105 active:scale-95 text-base shadow-lg">
                        Subscribe Now
                    </button>
                </form>
                <p class="mt-4 text-xs text-blue-200">We respect your privacy. No spam, just health updates.</p>
            </div>
        </div>
    </div>
</section>

<!-- Related Links -->
<section class="py-6 md:py-10 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-2xl font-bold text-gray-900 mb-8">Need Immediate Medical Advice?</h2>
        <div class="flex flex-wrap justify-center gap-4">
            <a href="{{ route('appointment.create') }}" class="px-8 py-4 bg-blue-600 text-white rounded-full font-bold hover:bg-blue-700 transition-all shadow-lg hover:shadow-xl transform hover:-translate-y-1">
                Book a Consultation
            </a>
            <a href="{{ route('contact.index') }}" class="px-8 py-4 bg-white text-blue-600 border-2 border-blue-600 rounded-full font-bold hover:bg-blue-50 transition-all shadow-md hover:shadow-lg transform hover:-translate-y-1">
                Contact Our Experts
            </a>
        </div>
    </div>
</section>
@endsection


